% GNF demo for self-organization with two hyperspheres 6D distribution

clear
NumSamples = 10000;
MaxNeurons = 50; % Maximum number of neurons in each graph
Dimension = 6;

% The following values of the parameters are those considered in the
% original GNG paper by Fritzke (1995)
Lambda=100;
Epochs=2;
EpsilonB=0.2;
EpsilonN=0.006;
Alpha=0.5;
AMax=50;
D=0.995;

% Generate data ('Swiss Roll' 3D distribution)
Samples1 = insideSphereGen(Dimension,NumSamples);
Samples2 = insideSphereGen(Dimension,NumSamples);NumSteps = NumSamples*Epochs;
Samples = [Samples1 Samples2+repmat([4 2 5 -2 1 2]',[1 NumSamples])];

% GNF Training
[Model] = TrainGNF(Samples,MaxNeurons,Lambda,EpsilonB,EpsilonN,Alpha,AMax,D,NumSteps);

% Plot the Model
figure, plot(Samples(1,:),Samples(2,:),'.k');
axis equal;
hold on;
uistack(gcf,'bottom');
PlotGNF(Model);   
axis off
disp('Press any key to continue...');
pause
close
figure, plot(Samples(3,:),Samples(4,:),'.k');
axis equal;
hold on;
uistack(gcf,'bottom');
PlotGNFShift(Model,2);  
axis off
disp('Press any key to continue...');
pause
close
figure, plot(Samples(5,:),Samples(6,:),'.k');
axis equal;
hold on;
uistack(gcf,'bottom');
PlotGNFShift(Model,4);
axis off